-- phpMyAdmin SQL Dump
-- version 5.0.2
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1:3306
-- Tempo de geração: 04-Jun-2025 às 11:10
-- Versão do servidor: 5.7.31
-- versão do PHP: 7.4.9

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Banco de dados: `centroformacao`
--

-- --------------------------------------------------------

--
-- Estrutura da tabela `aluno`
--

DROP TABLE IF EXISTS `aluno`;
CREATE TABLE IF NOT EXISTS `aluno` (
  `idAluno` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `idTipoUsuario` int(11) UNSIGNED DEFAULT NULL,
  `nome` varchar(255) DEFAULT NULL,
  `dataNasc` date DEFAULT NULL,
  `genero` enum('Masculino','Feminino') DEFAULT NULL,
  `bi` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `telefone` int(20) DEFAULT NULL,
  `endereco` text,
  `dataAdesao` date DEFAULT NULL,
  `imagem` text,
  `idPeriodo` int(11) UNSIGNED DEFAULT NULL,
  `idCurso` int(11) UNSIGNED DEFAULT NULL,
  `nomeUsuario` varchar(255) DEFAULT NULL,
  `senha` varchar(255) DEFAULT NULL,
  `estado` enum('Activo','Inactivo') DEFAULT 'Activo',
  PRIMARY KEY (`idAluno`),
  KEY `fk_idTipoUsuario_aluno` (`idTipoUsuario`),
  KEY `fk_idPeriodo_aluno` (`idPeriodo`),
  KEY `fk_idCurso_aluno` (`idCurso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estrutura da tabela `ano`
--

DROP TABLE IF EXISTS `ano`;
CREATE TABLE IF NOT EXISTS `ano` (
  `idAno` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(255) DEFAULT NULL,
  `descricao` varchar(255) DEFAULT NULL,
  `inicio` date DEFAULT NULL,
  `fim` date DEFAULT NULL,
  PRIMARY KEY (`idAno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estrutura da tabela `artigo`
--

DROP TABLE IF EXISTS `artigo`;
CREATE TABLE IF NOT EXISTS `artigo` (
  `idArtigo` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `idTipoArtigo` int(11) UNSIGNED DEFAULT NULL,
  `nome` varchar(255) DEFAULT NULL,
  `preco` double(10,2) DEFAULT NULL,
  `nota` text,
  PRIMARY KEY (`idArtigo`),
  KEY `fk_idTipoArtigo_artigo` (`idTipoArtigo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estrutura da tabela `artigofactura`
--

DROP TABLE IF EXISTS `artigofactura`;
CREATE TABLE IF NOT EXISTS `artigofactura` (
  `idFactura` int(11) UNSIGNED DEFAULT NULL,
  `idTipoArtigo` int(11) UNSIGNED DEFAULT NULL,
  `idArtigo` int(11) UNSIGNED DEFAULT NULL,
  `qtd` int(255) DEFAULT NULL,
  `preco` double(10,2) DEFAULT NULL,
  `total` double(10,2) GENERATED ALWAYS AS ((`qtd` * `preco`)) STORED,
  KEY `fk_idFactura_artigoFactura` (`idFactura`),
  KEY `fk_idTipoArtigo_artigoFactura` (`idTipoArtigo`),
  KEY `fk_idArtigo_artigoFactura` (`idArtigo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estrutura da tabela `configuracao`
--

DROP TABLE IF EXISTS `configuracao`;
CREATE TABLE IF NOT EXISTS `configuracao` (
  `idConfiguracao` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `campo` varchar(255) DEFAULT NULL,
  `valor` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`idConfiguracao`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

--
-- Extraindo dados da tabela `configuracao`
--

INSERT INTO `configuracao` (`idConfiguracao`, `campo`, `valor`) VALUES
(1, 'logo', 'logo.63611e6a95fb51.58829831.png'),
(2, 'titulo', 'MAYONGI ANGOLA'),
(3, 'rodape', 'Copyright &copy;'),
(4, 'endereco', ' Viana, Km-25'),
(5, 'telefone', '936054568'),
(6, 'email', 'Nilton-alfredo@hotmail.com'),
(7, 'nif', '4356123456'),
(8, 'site', 'mayongiangola.aoaaa');

-- --------------------------------------------------------

--
-- Estrutura da tabela `curso`
--

DROP TABLE IF EXISTS `curso`;
CREATE TABLE IF NOT EXISTS `curso` (
  `idCurso` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `idPeriodo` int(11) UNSIGNED DEFAULT NULL,
  `idDuracao` int(11) UNSIGNED DEFAULT NULL,
  `nome` varchar(255) DEFAULT NULL,
  `preco` float DEFAULT NULL,
  `nota` text,
  `imagem` text,
  `estado` enum('Activo','Inactivo') DEFAULT 'Activo',
  PRIMARY KEY (`idCurso`),
  KEY `fk_idPeriodo_curso` (`idPeriodo`),
  KEY `fk_idDuracao_curso` (`idDuracao`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;

--
-- Extraindo dados da tabela `curso`
--

INSERT INTO `curso` (`idCurso`, `idPeriodo`, `idDuracao`, `nome`, `preco`, `nota`, `imagem`, `estado`) VALUES
(25, 5, 29, 'Curso de gestÃ£o', 20000, NULL, NULL, 'Activo'),
(26, 6, 29, 'Contabilidade', 15000, NULL, NULL, 'Activo'),
(27, 5, 29, 'Testa curso', 200, NULL, NULL, 'Activo'),
(28, 5, 29, 'Teste de LicenÃ§a', 100, NULL, NULL, 'Activo'),
(29, 5, 30, 'fgvdfg', 46456, NULL, NULL, 'Activo'),
(30, 5, 29, 'sdfdgnilton', 12, NULL, NULL, 'Activo'),
(31, 5, 29, 'Teste de LicenÃ§a', 12345, NULL, '34.jpg', 'Activo'),
(32, 5, 29, 'sdgdfg', 45756, 'E agora sao', 'contabilidade-basica.jpg', 'Activo'),
(33, 6, 30, 'dfsf', 565, 'dgdfg', 'gestao-empresarial-completo.jpg', 'Activo');

-- --------------------------------------------------------

--
-- Estrutura da tabela `doc`
--

DROP TABLE IF EXISTS `doc`;
CREATE TABLE IF NOT EXISTS `doc` (
  `idUsuario` int(11) UNSIGNED DEFAULT NULL,
  `nomeDoc` varchar(255) DEFAULT NULL,
  `caminho` text,
  KEY `fk_idUsuario_doc` (`idUsuario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estrutura da tabela `duracao`
--

DROP TABLE IF EXISTS `duracao`;
CREATE TABLE IF NOT EXISTS `duracao` (
  `idDuracao` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(255) DEFAULT NULL,
  `inicio` date DEFAULT NULL,
  `final` date DEFAULT NULL,
  `nMes` int(11) UNSIGNED DEFAULT NULL,
  `nota` text,
  PRIMARY KEY (`idDuracao`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

--
-- Extraindo dados da tabela `duracao`
--

INSERT INTO `duracao` (`idDuracao`, `nome`, `inicio`, `final`, `nMes`, `nota`) VALUES
(29, 'Trimestral', '2022-12-01', '2023-03-31', NULL, NULL),
(30, 'Semestral', '2023-05-01', '2023-10-05', NULL, NULL);

--
-- Acionadores `duracao`
--
DROP TRIGGER IF EXISTS `trdeletecurso`;
DELIMITER $$
CREATE TRIGGER `trdeletecurso` BEFORE DELETE ON `duracao` FOR EACH ROW BEGIN
	DELETE FROM duracaocurso WHERE idDuracao = OLD.idDuracao;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Estrutura da tabela `duracaocurso`
--

DROP TABLE IF EXISTS `duracaocurso`;
CREATE TABLE IF NOT EXISTS `duracaocurso` (
  `idDuracaoCurso` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `idDuracao` int(11) UNSIGNED DEFAULT NULL,
  `descricao` varchar(255) DEFAULT NULL,
  `estado` enum('Activo','Inactivo') DEFAULT 'Activo',
  PRIMARY KEY (`idDuracaoCurso`),
  KEY `fk_idDuracao_duracaoCurso` (`idDuracao`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8;

--
-- Extraindo dados da tabela `duracaocurso`
--

INSERT INTO `duracaocurso` (`idDuracaoCurso`, `idDuracao`, `descricao`, `estado`) VALUES
(48, 29, 'December - 2022', 'Activo'),
(49, 29, 'January - 2023', 'Activo'),
(50, 29, 'February - 2023', 'Activo'),
(51, 29, 'March - 2023', 'Activo'),
(52, 29, 'April - 2023', 'Activo'),
(53, 29, 'May - 2023', 'Activo'),
(54, 29, 'June - 2023', 'Activo'),
(55, 29, 'July - 2023', 'Activo'),
(56, 29, 'August - 2023', 'Activo'),
(57, 29, 'September - 2023', 'Activo'),
(58, 29, 'October - 2023', 'Activo'),
(59, 29, 'November - 2023', 'Activo'),
(60, 29, 'December - 2023', 'Activo'),
(61, 30, 'May - 2023', 'Activo'),
(62, 30, 'June - 2023', 'Activo'),
(63, 30, 'July - 2023', 'Activo'),
(64, 30, 'August - 2023', 'Activo'),
(65, 30, 'September - 2023', 'Activo'),
(66, 30, 'October - 2023', 'Activo'),
(67, 30, 'November - 2023', 'Activo'),
(68, 30, 'December - 2023', 'Activo');

-- --------------------------------------------------------

--
-- Estrutura da tabela `factura`
--

DROP TABLE IF EXISTS `factura`;
CREATE TABLE IF NOT EXISTS `factura` (
  `idFactura` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `idUsuario` int(11) UNSIGNED DEFAULT NULL,
  `montanteTotal` double(10,2) DEFAULT NULL,
  `descontoTotal` double(10,2) DEFAULT NULL,
  `subTotal` double(10,2) DEFAULT NULL,
  `entregueTotal` double(10,2) DEFAULT NULL,
  `totalQtd` int(255) DEFAULT NULL,
  `troco` double(10,2) DEFAULT NULL,
  `estado` tinyint(4) DEFAULT NULL,
  `dataTempo` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`idFactura`),
  KEY `fk_idUsuario_factura` (`idUsuario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estrutura da tabela `identificador`
--

DROP TABLE IF EXISTS `identificador`;
CREATE TABLE IF NOT EXISTS `identificador` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `usuario` int(11) UNSIGNED DEFAULT NULL,
  `tipoUsuario` int(11) UNSIGNED DEFAULT NULL,
  `descricao` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_usuario_identificador` (`usuario`),
  KEY `fk_tipoUsuario_identificador` (`tipoUsuario`)
) ENGINE=InnoDB AUTO_INCREMENT=245 DEFAULT CHARSET=utf8;

--
-- Extraindo dados da tabela `identificador`
--

INSERT INTO `identificador` (`id`, `usuario`, `tipoUsuario`, `descricao`) VALUES
(238, 386, 3, 'PR3N1'),
(239, 387, 3, 'PR3N2'),
(241, 1, 1, 'AD1N1'),
(242, 388, 2, 'AL2N1'),
(243, 389, 2, 'AL2N2'),
(244, 390, 3, 'PR3N3');

-- --------------------------------------------------------

--
-- Estrutura da tabela `mensalidade`
--

DROP TABLE IF EXISTS `mensalidade`;
CREATE TABLE IF NOT EXISTS `mensalidade` (
  `idMensalidade` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(255) DEFAULT NULL,
  `preco` decimal(10,2) DEFAULT NULL,
  `nota` text,
  PRIMARY KEY (`idMensalidade`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estrutura da tabela `periodo`
--

DROP TABLE IF EXISTS `periodo`;
CREATE TABLE IF NOT EXISTS `periodo` (
  `idPeriodo` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(255) DEFAULT NULL,
  `inicio` time DEFAULT NULL,
  `final` time DEFAULT NULL,
  `nota` text,
  PRIMARY KEY (`idPeriodo`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

--
-- Extraindo dados da tabela `periodo`
--

INSERT INTO `periodo` (`idPeriodo`, `nome`, `inicio`, `final`, `nota`) VALUES
(5, 'ManhÃ£', '08:00:00', '12:30:00', NULL),
(6, 'Tarde', '13:00:00', '17:45:00', NULL);

-- --------------------------------------------------------

--
-- Estrutura da tabela `periodocursoaluno`
--

DROP TABLE IF EXISTS `periodocursoaluno`;
CREATE TABLE IF NOT EXISTS `periodocursoaluno` (
  `aluno` int(11) UNSIGNED DEFAULT NULL,
  `periodo` int(11) UNSIGNED DEFAULT NULL,
  `curso` int(11) UNSIGNED DEFAULT NULL,
  KEY `fk_idUsuario_periodocursoaluno` (`aluno`),
  KEY `fk_idPeriodo_periodocursoaluno` (`periodo`),
  KEY `fk_idCurso_periodocursoaluno` (`curso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Extraindo dados da tabela `periodocursoaluno`
--

INSERT INTO `periodocursoaluno` (`aluno`, `periodo`, `curso`) VALUES
(388, 5, 25),
(389, 5, 25);

-- --------------------------------------------------------

--
-- Estrutura da tabela `permissao`
--

DROP TABLE IF EXISTS `permissao`;
CREATE TABLE IF NOT EXISTS `permissao` (
  `idPermissao` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(255) DEFAULT NULL,
  `create` tinyint(1) DEFAULT NULL,
  `read` tinyint(1) DEFAULT NULL,
  `update` tinyint(1) DEFAULT NULL,
  `delete` tinyint(1) DEFAULT NULL,
  `parent_id` int(11) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (`idPermissao`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

--
-- Extraindo dados da tabela `permissao`
--

INSERT INTO `permissao` (`idPermissao`, `nome`, `create`, `read`, `update`, `delete`, `parent_id`) VALUES
(1, 'sistema', 1, 1, 1, 1, 0),
(2, 'aluno', 1, 1, 1, 1, 1),
(3, 'professor', 1, 1, 1, 1, 1),
(4, 'usuario', 1, 1, 1, 1, 1),
(5, 'academico', 1, 1, 1, 1, 1),
(6, 'periodo', 1, 1, 1, 1, 5),
(7, 'duracao', 1, 1, 1, 1, 5),
(8, 'curso', 1, 1, 1, 1, 5),
(9, 'turma', 1, 1, 1, 1, 5),
(10, 'conta', 1, 1, 1, 1, 1),
(11, 'tipo artigo', 1, 1, 1, 1, 10),
(12, 'artigo', 1, 1, 1, 1, 10),
(13, 'factura', 1, 1, 1, 1, 10),
(14, 'historico pagamento', 1, 1, 1, 1, 10),
(15, 'relatorio', 1, 1, 1, 1, 1),
(16, 'aluno', 1, 1, 1, 1, 15),
(17, 'certificado', 1, 1, 1, 1, 15),
(18, 'administrador', 1, 1, 1, 1, 1),
(19, 'tipo usuario', 1, 1, 1, 1, 18),
(20, 'ano academico', 1, 1, 1, 1, 18),
(21, 'modelo certificado', 1, 1, 1, 1, 18),
(22, 'alterar senha', 1, 1, 1, 1, 18),
(23, 'importar', 1, 1, 1, 1, 18),
(24, 'backup', 1, 1, 1, 1, 18),
(25, 'permissao', 1, 1, 1, 1, 18),
(26, 'definicoes', 1, 1, 1, 1, 1),
(27, 'configuracao geral', 1, 1, 1, 1, 26),
(28, 'sobre', 1, 1, 1, 1, 26),
(29, 'periodo 2', 1, 1, 1, 1, 6);

-- --------------------------------------------------------

--
-- Estrutura da tabela `teste`
--

DROP TABLE IF EXISTS `teste`;
CREATE TABLE IF NOT EXISTS `teste` (
  `idTeste` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `descricao` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`idTeste`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estrutura da tabela `tipoartigo`
--

DROP TABLE IF EXISTS `tipoartigo`;
CREATE TABLE IF NOT EXISTS `tipoartigo` (
  `idTipoArtigo` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(255) DEFAULT NULL,
  `nota` text,
  PRIMARY KEY (`idTipoArtigo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Estrutura da tabela `tipousuario`
--

DROP TABLE IF EXISTS `tipousuario`;
CREATE TABLE IF NOT EXISTS `tipousuario` (
  `idTipoUsuario` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `nome` varchar(255) DEFAULT NULL,
  `nota` text,
  PRIMARY KEY (`idTipoUsuario`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Extraindo dados da tabela `tipousuario`
--

INSERT INTO `tipousuario` (`idTipoUsuario`, `nome`, `nota`) VALUES
(1, 'Admin', NULL),
(2, 'Aluno', NULL),
(3, 'Professor', NULL),
(4, 'Gerente', NULL),
(5, 'Recepcionista', NULL);

-- --------------------------------------------------------

--
-- Estrutura da tabela `turma`
--

DROP TABLE IF EXISTS `turma`;
CREATE TABLE IF NOT EXISTS `turma` (
  `idTurma` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `idPeriodo` int(11) UNSIGNED DEFAULT NULL,
  `idCurso` int(11) UNSIGNED DEFAULT NULL,
  `nome` varchar(255) DEFAULT NULL,
  `capacidade` int(11) UNSIGNED DEFAULT NULL,
  `nota` text,
  PRIMARY KEY (`idTurma`),
  KEY `fk_idCurso_turma` (`idCurso`),
  KEY `fk_idPeriodo_turma` (`idPeriodo`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8;

--
-- Extraindo dados da tabela `turma`
--

INSERT INTO `turma` (`idTurma`, `idPeriodo`, `idCurso`, `nome`, `capacidade`, `nota`) VALUES
(41, 5, 25, 'Turma de GestÃ£o A', 38, ''),
(42, 5, 25, 'Curso de gestÃ£o B', 20, ''),
(43, 6, 26, 'Turma de Contabilidade A', 35, '');

-- --------------------------------------------------------

--
-- Estrutura da tabela `turmaaluno`
--

DROP TABLE IF EXISTS `turmaaluno`;
CREATE TABLE IF NOT EXISTS `turmaaluno` (
  `turma` int(11) UNSIGNED DEFAULT NULL,
  `aluno` int(11) UNSIGNED DEFAULT NULL,
  KEY `fk_turma_turmaAluno` (`turma`),
  KEY `fk_aluno_turmaAluno` (`aluno`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Extraindo dados da tabela `turmaaluno`
--

INSERT INTO `turmaaluno` (`turma`, `aluno`) VALUES
(41, 388),
(41, 389);

-- --------------------------------------------------------

--
-- Estrutura da tabela `turmaprof`
--

DROP TABLE IF EXISTS `turmaprof`;
CREATE TABLE IF NOT EXISTS `turmaprof` (
  `turma` int(11) UNSIGNED DEFAULT NULL,
  `professor` int(11) UNSIGNED DEFAULT NULL,
  KEY `fk_turma_turmaProf` (`turma`),
  KEY `fk_professor_turmaProf` (`professor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Extraindo dados da tabela `turmaprof`
--

INSERT INTO `turmaprof` (`turma`, `professor`) VALUES
(41, 386),
(42, 386),
(42, 387),
(43, 386);

-- --------------------------------------------------------

--
-- Estrutura da tabela `usuario`
--

DROP TABLE IF EXISTS `usuario`;
CREATE TABLE IF NOT EXISTS `usuario` (
  `idUsuario` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `idTipoUsuario` int(11) UNSIGNED DEFAULT NULL,
  `nome` varchar(255) DEFAULT NULL,
  `dataNasc` date DEFAULT NULL,
  `genero` enum('Masculino','Feminino') DEFAULT NULL,
  `bi` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `telefone` int(20) DEFAULT NULL,
  `endereco` text,
  `dataAdesao` date DEFAULT NULL,
  `imagem` text,
  `nomeUsuario` varchar(255) DEFAULT NULL,
  `senha` varchar(255) DEFAULT NULL,
  `estado` enum('Activo','Inactivo') DEFAULT 'Activo',
  PRIMARY KEY (`idUsuario`),
  KEY `fk_idTipoUsuario_usuario` (`idTipoUsuario`)
) ENGINE=InnoDB AUTO_INCREMENT=391 DEFAULT CHARSET=utf8;

--
-- Extraindo dados da tabela `usuario`
--

INSERT INTO `usuario` (`idUsuario`, `idTipoUsuario`, `nome`, `dataNasc`, `genero`, `bi`, `email`, `telefone`, `endereco`, `dataAdesao`, `imagem`, `nomeUsuario`, `senha`, `estado`) VALUES
(1, 1, 'admin', '2022-11-03', 'Masculino', '2sdf', 'admin@gmail.com', 223, '2asf', NULL, 'admin.63612c505eb643.53517105.jpg', 'admin', '$2y$10$RHJAeby2VQ5JZuLYg9ZDU.CKynKeXG07Jl.aRzJwJHLpyPWdoZ2XK', 'Activo'),
(386, 3, 'JoÃ£o Antunes', '2022-12-26', 'Masculino', '99999', 'joÃ£o@gmail.com', 924567543, 'Viana', NULL, '.638f1565d08b85.85857385.jpg', NULL, NULL, 'Activo'),
(387, 3, 'Manuel', '2022-12-27', 'Masculino', 'tytryt', 'manuel@gmail.com', 565, 'dfgdgf', NULL, '.638f15a894dfc0.84763242.jpg', NULL, NULL, 'Activo'),
(388, 2, 'Teste de LicenÃ§a', '2023-01-24', 'Feminino', '56456', 'email@gmail.com', 923, 'Rua 137, Casa n4', NULL, NULL, NULL, NULL, 'Activo'),
(389, 2, 'nilton Alfredo', '2023-01-11', 'Masculino', '006', 'email@ggmail.com', 924140471, 'Rua 137, Casa n4', NULL, '389.63c5aaab76d604.22056276.jpg', NULL, NULL, 'Activo'),
(390, 3, 'dfbfgb', '2023-04-17', 'Masculino', 'dfgdg', 'nilton4004@gmail.com', 564564564, 'dfgdfg', NULL, NULL, NULL, NULL, 'Activo');

--
-- Acionadores `usuario`
--
DROP TRIGGER IF EXISTS `trdeleteusuario`;
DELIMITER $$
CREATE TRIGGER `trdeleteusuario` BEFORE DELETE ON `usuario` FOR EACH ROW BEGIN
	IF OLD.idTipoUsuario = 2 THEN
    DELETE FROM turmaaluno WHERE aluno = OLD.idUsuario;
    ELSEIF OLD.idTipoUsuario = 3 THEN
    DELETE FROM turmaprof WHERE professor = OLD.idUsuario;
    END IF;
END
$$
DELIMITER ;
DROP TRIGGER IF EXISTS `trinsertusuario`;
DELIMITER $$
CREATE TRIGGER `trinsertusuario` AFTER INSERT ON `usuario` FOR EACH ROW BEGIN
	DECLARE codigo VARCHAR (255);
    SELECT CONCAT(UPPER(LEFT(tu.nome, 2)), tu.idTipoUsuario, "N", COUNT(*)) FROM usuario u INNER JOIN tipoUsuario tu ON (u.idTipoUsuario=tu.idTipoUsuario) WHERE u.idTipoUsuario = NEW.idTipoUsuario INTO codigo;
    INSERT INTO identificador SET
		usuario = NEW.idUsuario,
        tipoUsuario = NEW.idTipoUsuario,
        descricao = codigo;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Estrutura stand-in para vista `viewartigotipoartigo`
-- (Veja abaixo para a view atual)
--
DROP VIEW IF EXISTS `viewartigotipoartigo`;
CREATE TABLE IF NOT EXISTS `viewartigotipoartigo` (
`idArtigo` int(11) unsigned
,`idTipoArtigo` int(11) unsigned
,`nome` varchar(255)
,`preco` double(10,2)
,`nota` text
,`tipoArtigo` varchar(255)
);

-- --------------------------------------------------------

--
-- Estrutura stand-in para vista `viewcodigoalunoturma`
-- (Veja abaixo para a view atual)
--
DROP VIEW IF EXISTS `viewcodigoalunoturma`;
CREATE TABLE IF NOT EXISTS `viewcodigoalunoturma` (
`id` int(11) unsigned
,`usuario` int(11) unsigned
,`tipoUsuario` int(11) unsigned
,`descricao` varchar(255)
,`turma` int(11) unsigned
,`aluno` int(11) unsigned
,`idTurma` int(11) unsigned
,`idPeriodo` int(11) unsigned
,`idCurso` int(11) unsigned
,`nome_turma` varchar(255)
,`capacidade` int(11) unsigned
,`idUsuario` int(11) unsigned
,`idTipoUsuario` int(11) unsigned
,`nome` varchar(255)
,`dataNasc` date
,`genero` enum('Masculino','Feminino')
,`bi` varchar(255)
,`email` varchar(255)
,`telefone` int(20)
,`endereco` text
,`dataAdesao` date
,`imagem` text
,`nomeUsuario` varchar(255)
,`senha` varchar(255)
,`estado` enum('Activo','Inactivo')
);

-- --------------------------------------------------------

--
-- Estrutura stand-in para vista `viewcursoperiododuracao`
-- (Veja abaixo para a view atual)
--
DROP VIEW IF EXISTS `viewcursoperiododuracao`;
CREATE TABLE IF NOT EXISTS `viewcursoperiododuracao` (
`idCurso` int(11) unsigned
,`idPeriodo` int(11) unsigned
,`idDuracao` int(11) unsigned
,`nome` varchar(255)
,`preco` float
,`nota` text
,`imagem` text
,`estado` enum('Activo','Inactivo')
,`periodo` varchar(255)
,`duracao` varchar(255)
);

-- --------------------------------------------------------

--
-- Estrutura stand-in para vista `viewcursoturma`
-- (Veja abaixo para a view atual)
--
DROP VIEW IF EXISTS `viewcursoturma`;
CREATE TABLE IF NOT EXISTS `viewcursoturma` (
`idCurso` int(11) unsigned
,`idPeriodo` int(11) unsigned
,`idDuracao` int(11) unsigned
,`nome` varchar(255)
,`preco` float
,`nota` text
,`capacidade` int(11) unsigned
,`periodo` int(11) unsigned
,`idTurma` int(11) unsigned
,`turma` varchar(255)
,`turmaNota` text
);

-- --------------------------------------------------------

--
-- Estrutura stand-in para vista `viewdataaluno`
-- (Veja abaixo para a view atual)
--
DROP VIEW IF EXISTS `viewdataaluno`;
CREATE TABLE IF NOT EXISTS `viewdataaluno` (
`idUsuario` int(11) unsigned
,`idTipoUsuario` int(11) unsigned
,`nome` varchar(255)
,`dataNasc` date
,`genero` enum('Masculino','Feminino')
,`bi` varchar(255)
,`email` varchar(255)
,`telefone` int(20)
,`endereco` text
,`dataAdesao` date
,`imagem` text
,`nomeUsuario` varchar(255)
,`senha` varchar(255)
,`estado` enum('Activo','Inactivo')
,`tipoUsuario` varchar(255)
,`idTurma` int(11) unsigned
,`turma` varchar(255)
,`idPeriodo` int(11) unsigned
,`periodo` varchar(255)
,`idCurso` int(11) unsigned
,`curso` varchar(255)
,`codigo` varchar(255)
);

-- --------------------------------------------------------

--
-- Estrutura stand-in para vista `viewdatausuario`
-- (Veja abaixo para a view atual)
--
DROP VIEW IF EXISTS `viewdatausuario`;
CREATE TABLE IF NOT EXISTS `viewdatausuario` (
`idUsuario` int(11) unsigned
,`idTipoUsuario` int(11) unsigned
,`nome` varchar(255)
,`dataNasc` date
,`genero` enum('Masculino','Feminino')
,`bi` varchar(255)
,`email` varchar(255)
,`telefone` int(20)
,`endereco` text
,`dataAdesao` date
,`imagem` text
,`nomeUsuario` varchar(255)
,`senha` varchar(255)
,`estado` enum('Activo','Inactivo')
,`tipoUsuario` varchar(255)
,`codigo` varchar(255)
);

-- --------------------------------------------------------

--
-- Estrutura stand-in para vista `viewfacturaaluno`
-- (Veja abaixo para a view atual)
--
DROP VIEW IF EXISTS `viewfacturaaluno`;
CREATE TABLE IF NOT EXISTS `viewfacturaaluno` (
`idFactura` int(11) unsigned
,`idUsuario` int(11) unsigned
,`montanteTotal` double(10,2)
,`descontoTotal` double(10,2)
,`subTotal` double(10,2)
,`entregueTotal` double(10,2)
,`totalQtd` int(255)
,`troco` double(10,2)
,`estado` tinyint(4)
,`dataTempo` datetime
,`aluno` varchar(255)
,`curso` varchar(255)
);

-- --------------------------------------------------------

--
-- Estrutura stand-in para vista `viewidentificadoruser`
-- (Veja abaixo para a view atual)
--
DROP VIEW IF EXISTS `viewidentificadoruser`;
CREATE TABLE IF NOT EXISTS `viewidentificadoruser` (
`idUsuario` int(11) unsigned
,`idTipoUsuario` int(11) unsigned
,`nome` varchar(255)
,`dataNasc` date
,`genero` enum('Masculino','Feminino')
,`bi` varchar(255)
,`email` varchar(255)
,`telefone` int(20)
,`endereco` text
,`dataAdesao` date
,`imagem` text
,`nomeUsuario` varchar(255)
,`senha` varchar(255)
,`estado` enum('Activo','Inactivo')
,`id` int(11) unsigned
,`usuario` int(11) unsigned
,`tipoUsuario` int(11) unsigned
,`descricao` varchar(255)
);

-- --------------------------------------------------------

--
-- Estrutura stand-in para vista `viewidentificadorusuario`
-- (Veja abaixo para a view atual)
--
DROP VIEW IF EXISTS `viewidentificadorusuario`;
CREATE TABLE IF NOT EXISTS `viewidentificadorusuario` (
`idUsuario` int(11) unsigned
,`idTipoUsuario` int(11) unsigned
,`nome` varchar(255)
,`dataNasc` date
,`genero` enum('Masculino','Feminino')
,`bi` varchar(255)
,`email` varchar(255)
,`telefone` int(20)
,`endereco` text
,`dataAdesao` date
,`imagem` text
,`nomeUsuario` varchar(255)
,`senha` varchar(255)
,`estado` enum('Activo','Inactivo')
,`id` int(11) unsigned
,`usuario` int(11) unsigned
,`tipoUsuario` int(11) unsigned
,`descricao` varchar(255)
,`turma` int(11) unsigned
,`aluno` int(11) unsigned
,`idTurma` int(11) unsigned
,`nomeTurma` varchar(255)
,`idPeriodo` int(11) unsigned
,`nomePeriodo` varchar(255)
,`idCurso` int(11) unsigned
,`nomeCurso` varchar(255)
,`idDuracao` int(11) unsigned
,`nomeDuracao` varchar(255)
);

-- --------------------------------------------------------

--
-- Estrutura stand-in para vista `viewperiodocursoturma`
-- (Veja abaixo para a view atual)
--
DROP VIEW IF EXISTS `viewperiodocursoturma`;
CREATE TABLE IF NOT EXISTS `viewperiodocursoturma` (
`idTurma` int(11) unsigned
,`idPeriodo` int(11) unsigned
,`idCurso` int(11) unsigned
,`nome` varchar(255)
,`capacidade` int(11) unsigned
,`nota` text
,`periodo` varchar(255)
,`curso` varchar(255)
);

-- --------------------------------------------------------

--
-- Estrutura stand-in para vista `viewusuariotipo`
-- (Veja abaixo para a view atual)
--
DROP VIEW IF EXISTS `viewusuariotipo`;
CREATE TABLE IF NOT EXISTS `viewusuariotipo` (
`idUsuario` int(11) unsigned
,`idTipoUsuario` int(11) unsigned
,`nome` varchar(255)
,`dataNasc` date
,`genero` enum('Masculino','Feminino')
,`bi` varchar(255)
,`email` varchar(255)
,`telefone` int(20)
,`endereco` text
,`dataAdesao` date
,`imagem` text
,`nomeUsuario` varchar(255)
,`senha` varchar(255)
,`estado` enum('Activo','Inactivo')
,`tipoUsuario` varchar(255)
);

-- --------------------------------------------------------

--
-- Estrutura stand-in para vista `viewusuariotipoidentificador`
-- (Veja abaixo para a view atual)
--
DROP VIEW IF EXISTS `viewusuariotipoidentificador`;
CREATE TABLE IF NOT EXISTS `viewusuariotipoidentificador` (
`idUsuario` int(11) unsigned
,`idTipoUsuario` int(11) unsigned
,`nome` varchar(255)
,`dataNasc` date
,`genero` enum('Masculino','Feminino')
,`bi` varchar(255)
,`email` varchar(255)
,`telefone` int(20)
,`endereco` text
,`dataAdesao` date
,`imagem` text
,`nomeUsuario` varchar(255)
,`senha` varchar(255)
,`estado` enum('Activo','Inactivo')
,`nomeTipoUsuario` varchar(255)
,`id` int(11) unsigned
,`usuario` int(11) unsigned
,`tipoUsuario` int(11) unsigned
,`descricao` varchar(255)
);

-- --------------------------------------------------------

--
-- Estrutura para vista `viewartigotipoartigo`
--
DROP TABLE IF EXISTS `viewartigotipoartigo`;

DROP VIEW IF EXISTS `viewartigotipoartigo`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `viewartigotipoartigo`  AS  select `a`.`idArtigo` AS `idArtigo`,`a`.`idTipoArtigo` AS `idTipoArtigo`,`a`.`nome` AS `nome`,`a`.`preco` AS `preco`,`a`.`nota` AS `nota`,`ta`.`nome` AS `tipoArtigo` from (`artigo` `a` join `tipoartigo` `ta` on((`a`.`idTipoArtigo` = `ta`.`idTipoArtigo`))) ;

-- --------------------------------------------------------

--
-- Estrutura para vista `viewcodigoalunoturma`
--
DROP TABLE IF EXISTS `viewcodigoalunoturma`;

DROP VIEW IF EXISTS `viewcodigoalunoturma`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `viewcodigoalunoturma`  AS  select `i`.`id` AS `id`,`i`.`usuario` AS `usuario`,`i`.`tipoUsuario` AS `tipoUsuario`,`i`.`descricao` AS `descricao`,`ta`.`turma` AS `turma`,`ta`.`aluno` AS `aluno`,`t`.`idTurma` AS `idTurma`,`t`.`idPeriodo` AS `idPeriodo`,`t`.`idCurso` AS `idCurso`,`t`.`nome` AS `nome_turma`,`t`.`capacidade` AS `capacidade`,`u`.`idUsuario` AS `idUsuario`,`u`.`idTipoUsuario` AS `idTipoUsuario`,`u`.`nome` AS `nome`,`u`.`dataNasc` AS `dataNasc`,`u`.`genero` AS `genero`,`u`.`bi` AS `bi`,`u`.`email` AS `email`,`u`.`telefone` AS `telefone`,`u`.`endereco` AS `endereco`,`u`.`dataAdesao` AS `dataAdesao`,`u`.`imagem` AS `imagem`,`u`.`nomeUsuario` AS `nomeUsuario`,`u`.`senha` AS `senha`,`u`.`estado` AS `estado` from (((`identificador` `i` join `turmaaluno` `ta` on((`i`.`usuario` = `ta`.`aluno`))) join `turma` `t` on((`ta`.`turma` = `t`.`idTurma`))) join `usuario` `u` on((`i`.`usuario` = `u`.`idUsuario`))) ;

-- --------------------------------------------------------

--
-- Estrutura para vista `viewcursoperiododuracao`
--
DROP TABLE IF EXISTS `viewcursoperiododuracao`;

DROP VIEW IF EXISTS `viewcursoperiododuracao`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `viewcursoperiododuracao`  AS  select `c`.`idCurso` AS `idCurso`,`c`.`idPeriodo` AS `idPeriodo`,`c`.`idDuracao` AS `idDuracao`,`c`.`nome` AS `nome`,`c`.`preco` AS `preco`,`c`.`nota` AS `nota`,`c`.`imagem` AS `imagem`,`c`.`estado` AS `estado`,`p`.`nome` AS `periodo`,`d`.`nome` AS `duracao` from ((`curso` `c` join `periodo` `p` on((`c`.`idPeriodo` = `p`.`idPeriodo`))) join `duracao` `d` on((`c`.`idDuracao` = `d`.`idDuracao`))) ;

-- --------------------------------------------------------

--
-- Estrutura para vista `viewcursoturma`
--
DROP TABLE IF EXISTS `viewcursoturma`;

DROP VIEW IF EXISTS `viewcursoturma`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `viewcursoturma`  AS  select `c`.`idCurso` AS `idCurso`,`c`.`idPeriodo` AS `idPeriodo`,`c`.`idDuracao` AS `idDuracao`,`c`.`nome` AS `nome`,`c`.`preco` AS `preco`,`c`.`nota` AS `nota`,`t`.`capacidade` AS `capacidade`,`t`.`idPeriodo` AS `periodo`,`t`.`idTurma` AS `idTurma`,`t`.`nome` AS `turma`,`t`.`nota` AS `turmaNota` from (`curso` `c` join `turma` `t` on((`c`.`idCurso` = `t`.`idCurso`))) ;

-- --------------------------------------------------------

--
-- Estrutura para vista `viewdataaluno`
--
DROP TABLE IF EXISTS `viewdataaluno`;

DROP VIEW IF EXISTS `viewdataaluno`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `viewdataaluno`  AS  select `u`.`idUsuario` AS `idUsuario`,`u`.`idTipoUsuario` AS `idTipoUsuario`,`u`.`nome` AS `nome`,`u`.`dataNasc` AS `dataNasc`,`u`.`genero` AS `genero`,`u`.`bi` AS `bi`,`u`.`email` AS `email`,`u`.`telefone` AS `telefone`,`u`.`endereco` AS `endereco`,`u`.`dataAdesao` AS `dataAdesao`,`u`.`imagem` AS `imagem`,`u`.`nomeUsuario` AS `nomeUsuario`,`u`.`senha` AS `senha`,`u`.`estado` AS `estado`,`tu`.`nome` AS `tipoUsuario`,`t`.`idTurma` AS `idTurma`,`t`.`nome` AS `turma`,`p`.`idPeriodo` AS `idPeriodo`,`p`.`nome` AS `periodo`,`c`.`idCurso` AS `idCurso`,`c`.`nome` AS `curso`,`i`.`descricao` AS `codigo` from ((((((`turmaaluno` `ta` join `usuario` `u` on((`ta`.`aluno` = `u`.`idUsuario`))) join `tipousuario` `tu` on((`u`.`idTipoUsuario` = `tu`.`idTipoUsuario`))) join `turma` `t` on((`ta`.`turma` = `t`.`idTurma`))) join `periodo` `p` on((`t`.`idPeriodo` = `p`.`idPeriodo`))) join `curso` `c` on((`t`.`idCurso` = `c`.`idCurso`))) join `identificador` `i` on((`u`.`idUsuario` = `i`.`usuario`))) ;

-- --------------------------------------------------------

--
-- Estrutura para vista `viewdatausuario`
--
DROP TABLE IF EXISTS `viewdatausuario`;

DROP VIEW IF EXISTS `viewdatausuario`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `viewdatausuario`  AS  select `u`.`idUsuario` AS `idUsuario`,`u`.`idTipoUsuario` AS `idTipoUsuario`,`u`.`nome` AS `nome`,`u`.`dataNasc` AS `dataNasc`,`u`.`genero` AS `genero`,`u`.`bi` AS `bi`,`u`.`email` AS `email`,`u`.`telefone` AS `telefone`,`u`.`endereco` AS `endereco`,`u`.`dataAdesao` AS `dataAdesao`,`u`.`imagem` AS `imagem`,`u`.`nomeUsuario` AS `nomeUsuario`,`u`.`senha` AS `senha`,`u`.`estado` AS `estado`,`tu`.`nome` AS `tipoUsuario`,`i`.`descricao` AS `codigo` from ((`usuario` `u` join `tipousuario` `tu` on((`u`.`idTipoUsuario` = `tu`.`idTipoUsuario`))) join `identificador` `i` on((`u`.`idUsuario` = `i`.`usuario`))) ;

-- --------------------------------------------------------

--
-- Estrutura para vista `viewfacturaaluno`
--
DROP TABLE IF EXISTS `viewfacturaaluno`;

DROP VIEW IF EXISTS `viewfacturaaluno`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `viewfacturaaluno`  AS  select `f`.`idFactura` AS `idFactura`,`f`.`idUsuario` AS `idUsuario`,`f`.`montanteTotal` AS `montanteTotal`,`f`.`descontoTotal` AS `descontoTotal`,`f`.`subTotal` AS `subTotal`,`f`.`entregueTotal` AS `entregueTotal`,`f`.`totalQtd` AS `totalQtd`,`f`.`troco` AS `troco`,`f`.`estado` AS `estado`,`f`.`dataTempo` AS `dataTempo`,`u`.`nome` AS `aluno`,`c`.`nome` AS `curso` from (((`factura` `f` join `usuario` `u` on((`f`.`idUsuario` = `u`.`idUsuario`))) join `periodocursoaluno` `pca` on((`u`.`idUsuario` = `pca`.`aluno`))) join `curso` `c` on((`pca`.`curso` = `c`.`idCurso`))) ;

-- --------------------------------------------------------

--
-- Estrutura para vista `viewidentificadoruser`
--
DROP TABLE IF EXISTS `viewidentificadoruser`;

DROP VIEW IF EXISTS `viewidentificadoruser`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `viewidentificadoruser`  AS  select `u`.`idUsuario` AS `idUsuario`,`u`.`idTipoUsuario` AS `idTipoUsuario`,`u`.`nome` AS `nome`,`u`.`dataNasc` AS `dataNasc`,`u`.`genero` AS `genero`,`u`.`bi` AS `bi`,`u`.`email` AS `email`,`u`.`telefone` AS `telefone`,`u`.`endereco` AS `endereco`,`u`.`dataAdesao` AS `dataAdesao`,`u`.`imagem` AS `imagem`,`u`.`nomeUsuario` AS `nomeUsuario`,`u`.`senha` AS `senha`,`u`.`estado` AS `estado`,`i`.`id` AS `id`,`i`.`usuario` AS `usuario`,`i`.`tipoUsuario` AS `tipoUsuario`,`i`.`descricao` AS `descricao` from (`usuario` `u` join `identificador` `i` on((`u`.`idUsuario` = `i`.`usuario`))) ;

-- --------------------------------------------------------

--
-- Estrutura para vista `viewidentificadorusuario`
--
DROP TABLE IF EXISTS `viewidentificadorusuario`;

DROP VIEW IF EXISTS `viewidentificadorusuario`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `viewidentificadorusuario`  AS  select `u`.`idUsuario` AS `idUsuario`,`u`.`idTipoUsuario` AS `idTipoUsuario`,`u`.`nome` AS `nome`,`u`.`dataNasc` AS `dataNasc`,`u`.`genero` AS `genero`,`u`.`bi` AS `bi`,`u`.`email` AS `email`,`u`.`telefone` AS `telefone`,`u`.`endereco` AS `endereco`,`u`.`dataAdesao` AS `dataAdesao`,`u`.`imagem` AS `imagem`,`u`.`nomeUsuario` AS `nomeUsuario`,`u`.`senha` AS `senha`,`u`.`estado` AS `estado`,`id`.`id` AS `id`,`id`.`usuario` AS `usuario`,`id`.`tipoUsuario` AS `tipoUsuario`,`id`.`descricao` AS `descricao`,`ta`.`turma` AS `turma`,`ta`.`aluno` AS `aluno`,`t`.`idTurma` AS `idTurma`,`t`.`nome` AS `nomeTurma`,`p`.`idPeriodo` AS `idPeriodo`,`p`.`nome` AS `nomePeriodo`,`c`.`idCurso` AS `idCurso`,`c`.`nome` AS `nomeCurso`,`d`.`idDuracao` AS `idDuracao`,`d`.`nome` AS `nomeDuracao` from ((((((`usuario` `u` join `identificador` `id` on((`u`.`idUsuario` = `id`.`usuario`))) join `turmaaluno` `ta` on((`u`.`idUsuario` = `ta`.`aluno`))) join `turma` `t` on((`ta`.`turma` = `t`.`idTurma`))) join `periodo` `p` on((`t`.`idPeriodo` = `p`.`idPeriodo`))) join `curso` `c` on((`t`.`idCurso` = `c`.`idCurso`))) join `duracao` `d` on((`c`.`idDuracao` = `d`.`idDuracao`))) ;

-- --------------------------------------------------------

--
-- Estrutura para vista `viewperiodocursoturma`
--
DROP TABLE IF EXISTS `viewperiodocursoturma`;

DROP VIEW IF EXISTS `viewperiodocursoturma`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `viewperiodocursoturma`  AS  select `t`.`idTurma` AS `idTurma`,`t`.`idPeriodo` AS `idPeriodo`,`t`.`idCurso` AS `idCurso`,`t`.`nome` AS `nome`,`t`.`capacidade` AS `capacidade`,`t`.`nota` AS `nota`,`p`.`nome` AS `periodo`,`c`.`nome` AS `curso` from ((`turma` `t` join `periodo` `p` on((`t`.`idPeriodo` = `p`.`idPeriodo`))) join `curso` `c` on((`t`.`idCurso` = `c`.`idCurso`))) ;

-- --------------------------------------------------------

--
-- Estrutura para vista `viewusuariotipo`
--
DROP TABLE IF EXISTS `viewusuariotipo`;

DROP VIEW IF EXISTS `viewusuariotipo`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `viewusuariotipo`  AS  select `u`.`idUsuario` AS `idUsuario`,`u`.`idTipoUsuario` AS `idTipoUsuario`,`u`.`nome` AS `nome`,`u`.`dataNasc` AS `dataNasc`,`u`.`genero` AS `genero`,`u`.`bi` AS `bi`,`u`.`email` AS `email`,`u`.`telefone` AS `telefone`,`u`.`endereco` AS `endereco`,`u`.`dataAdesao` AS `dataAdesao`,`u`.`imagem` AS `imagem`,`u`.`nomeUsuario` AS `nomeUsuario`,`u`.`senha` AS `senha`,`u`.`estado` AS `estado`,`tu`.`nome` AS `tipoUsuario` from (`usuario` `u` join `tipousuario` `tu` on((`u`.`idTipoUsuario` = `tu`.`idTipoUsuario`))) ;

-- --------------------------------------------------------

--
-- Estrutura para vista `viewusuariotipoidentificador`
--
DROP TABLE IF EXISTS `viewusuariotipoidentificador`;

DROP VIEW IF EXISTS `viewusuariotipoidentificador`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `viewusuariotipoidentificador`  AS  select `u`.`idUsuario` AS `idUsuario`,`u`.`idTipoUsuario` AS `idTipoUsuario`,`u`.`nome` AS `nome`,`u`.`dataNasc` AS `dataNasc`,`u`.`genero` AS `genero`,`u`.`bi` AS `bi`,`u`.`email` AS `email`,`u`.`telefone` AS `telefone`,`u`.`endereco` AS `endereco`,`u`.`dataAdesao` AS `dataAdesao`,`u`.`imagem` AS `imagem`,`u`.`nomeUsuario` AS `nomeUsuario`,`u`.`senha` AS `senha`,`u`.`estado` AS `estado`,`tu`.`nome` AS `nomeTipoUsuario`,`i`.`id` AS `id`,`i`.`usuario` AS `usuario`,`i`.`tipoUsuario` AS `tipoUsuario`,`i`.`descricao` AS `descricao` from ((`usuario` `u` join `tipousuario` `tu` on((`u`.`idTipoUsuario` = `tu`.`idTipoUsuario`))) join `identificador` `i` on((`u`.`idUsuario` = `i`.`usuario`))) ;

--
-- Restrições para despejos de tabelas
--

--
-- Limitadores para a tabela `aluno`
--
ALTER TABLE `aluno`
  ADD CONSTRAINT `fk_idCurso_aluno` FOREIGN KEY (`idCurso`) REFERENCES `curso` (`idCurso`),
  ADD CONSTRAINT `fk_idPeriodo_aluno` FOREIGN KEY (`idPeriodo`) REFERENCES `periodo` (`idPeriodo`),
  ADD CONSTRAINT `fk_idTipoUsuario_aluno` FOREIGN KEY (`idTipoUsuario`) REFERENCES `tipousuario` (`idTipoUsuario`);

--
-- Limitadores para a tabela `artigo`
--
ALTER TABLE `artigo`
  ADD CONSTRAINT `fk_idTipoArtigo_artigo` FOREIGN KEY (`idTipoArtigo`) REFERENCES `tipoartigo` (`idTipoArtigo`);

--
-- Limitadores para a tabela `artigofactura`
--
ALTER TABLE `artigofactura`
  ADD CONSTRAINT `fk_idArtigo_artigoFactura` FOREIGN KEY (`idArtigo`) REFERENCES `artigo` (`idArtigo`),
  ADD CONSTRAINT `fk_idFactura_artigoFactura` FOREIGN KEY (`idFactura`) REFERENCES `factura` (`idFactura`),
  ADD CONSTRAINT `fk_idTipoArtigo_artigoFactura` FOREIGN KEY (`idTipoArtigo`) REFERENCES `tipoartigo` (`idTipoArtigo`);

--
-- Limitadores para a tabela `curso`
--
ALTER TABLE `curso`
  ADD CONSTRAINT `fk_idDuracao_curso` FOREIGN KEY (`idDuracao`) REFERENCES `duracao` (`idDuracao`),
  ADD CONSTRAINT `fk_idPeriodo_curso` FOREIGN KEY (`idPeriodo`) REFERENCES `periodo` (`idPeriodo`);

--
-- Limitadores para a tabela `doc`
--
ALTER TABLE `doc`
  ADD CONSTRAINT `fk_idUsuario_doc` FOREIGN KEY (`idUsuario`) REFERENCES `usuario` (`idUsuario`);

--
-- Limitadores para a tabela `duracaocurso`
--
ALTER TABLE `duracaocurso`
  ADD CONSTRAINT `fk_idDuracao_duracaoCurso` FOREIGN KEY (`idDuracao`) REFERENCES `duracao` (`idDuracao`);

--
-- Limitadores para a tabela `factura`
--
ALTER TABLE `factura`
  ADD CONSTRAINT `fk_idUsuario_factura` FOREIGN KEY (`idUsuario`) REFERENCES `usuario` (`idUsuario`);

--
-- Limitadores para a tabela `identificador`
--
ALTER TABLE `identificador`
  ADD CONSTRAINT `fk_tipoUsuario_identificador` FOREIGN KEY (`tipoUsuario`) REFERENCES `tipousuario` (`idTipoUsuario`),
  ADD CONSTRAINT `fk_usuario_identificador` FOREIGN KEY (`usuario`) REFERENCES `usuario` (`idUsuario`);

--
-- Limitadores para a tabela `periodocursoaluno`
--
ALTER TABLE `periodocursoaluno`
  ADD CONSTRAINT `fk_idCurso_periodocursoaluno` FOREIGN KEY (`curso`) REFERENCES `curso` (`idCurso`),
  ADD CONSTRAINT `fk_idPeriodo_periodocursoaluno` FOREIGN KEY (`periodo`) REFERENCES `periodo` (`idPeriodo`),
  ADD CONSTRAINT `fk_idUsuario_periodocursoaluno` FOREIGN KEY (`aluno`) REFERENCES `usuario` (`idUsuario`);

--
-- Limitadores para a tabela `turma`
--
ALTER TABLE `turma`
  ADD CONSTRAINT `fk_idCurso_turma` FOREIGN KEY (`idCurso`) REFERENCES `curso` (`idCurso`),
  ADD CONSTRAINT `fk_idPeriodo_turma` FOREIGN KEY (`idPeriodo`) REFERENCES `periodo` (`idPeriodo`);

--
-- Limitadores para a tabela `turmaaluno`
--
ALTER TABLE `turmaaluno`
  ADD CONSTRAINT `fk_aluno_turmaAluno` FOREIGN KEY (`aluno`) REFERENCES `usuario` (`idUsuario`),
  ADD CONSTRAINT `fk_turma_turmaAluno` FOREIGN KEY (`turma`) REFERENCES `turma` (`idTurma`);

--
-- Limitadores para a tabela `turmaprof`
--
ALTER TABLE `turmaprof`
  ADD CONSTRAINT `fk_professor_turmaProf` FOREIGN KEY (`professor`) REFERENCES `usuario` (`idUsuario`),
  ADD CONSTRAINT `fk_turma_turmaProf` FOREIGN KEY (`turma`) REFERENCES `turma` (`idTurma`);

--
-- Limitadores para a tabela `usuario`
--
ALTER TABLE `usuario`
  ADD CONSTRAINT `fk_idTipoUsuario_usuario` FOREIGN KEY (`idTipoUsuario`) REFERENCES `tipousuario` (`idTipoUsuario`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
