<?php
    class ArtigoModel extends Database {

		protected function insertArtigo($nome, $tipoArtigo, $preco, $nota){
            $stmt = $this->connect();
            $sql = "INSERT INTO artigo (nome, idTipoArtigo, preco, nota) VALUES (?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($nome, $tipoArtigo, $preco, $nota)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function editArtigo($idArtigo, $nome, $idTipoArtigo, $preco, $nota){
			$stmt = $this->connect();
			
            $sql = "UPDATE artigo SET idTipoArtigo = ?, nome = ?, preco = ?, nota = ? WHERE idArtigo = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idTipoArtigo, $nome, $preco, $nota, $idArtigo)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function dataAlunoArtigo(){
			$data = null;
			$sql = "SELECT * FROM viewidentificadorusuario";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryAlunoArtigo($codigo){
			$data = null;
			$sql = "SELECT * FROM viewidentificadorusuario WHERE descricao = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$codigo]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function listagemArtigo(){
			$data = null;
			$sql = "SELECT * FROM viewartigotipoartigo";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryArtigo($idArtigo){
			$data = null;
			$sql = "SELECT * FROM artigo WHERE idArtigo = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idArtigo]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryArtigoTipo($idArtigo){
			$data = null;
			$sql = "SELECT * FROM artigo WHERE idTipoArtigo = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idArtigo]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function deleteArtigo($idArtigo){
			$stmt = $this->connect();
            $sql = "DELETE FROM artigo WHERE idArtigo = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idArtigo)))){
				$query = null;
				exit();
			}
		}

    }