<?php
    class FotoModel extends Database {

		protected function insertFoto($id, $ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido, $nomeCompletoImagem, $destinoFicheiro){
			$stmt = $this->connect();
			
            $sql = "UPDATE usuario SET imagem = ? WHERE idUsuario = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nomeCompletoImagem, $id)))){
				$query = null;
				exit();
			}
            move_uploaded_file($nomeTemporarioFicheiro, $destinoFicheiro);
			$id = $stmt->lastInsertId();
			
			return $id;
        }

		protected function insertFotoCurso($id, $ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido, $nomeCompletoImagem, $destinoFicheiro){
			$stmt = $this->connect();
			
            $sql = "UPDATE curso SET imagem = ? WHERE idCurso = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nomeCompletoImagem, $id)))){
				$query = null;
				exit();
			}
            move_uploaded_file($nomeTemporarioFicheiro, $destinoFicheiro);
			$id = $stmt->lastInsertId();
			
			return $id;
        }

		public function insertUsuario($nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario, $periodo, $curso){
			$stmt = $this->connect();
			
            $sql = "INSERT INTO usuario (nome, email, dataNasc, telefone, endereco, bi, genero, idTipoUsuario) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			$this->insertPeriodoCurso($id, $periodo, $curso);
			$idTurma = $this->getTurma($periodo, $curso);
			$this->insertTurmaAluno($idTurma[0]["idTurma"], $id);
			$this->editTurma($idTurma[0]["idTurma"], $idTurma[0]["capacidade"]);
			$capacidade = $this->verifyTurma($idTurma[0]["idTurma"]);
			$idTurma2 = $this->getTurma($periodo, $curso);
			if($idTurma2 == null){
				$this->editStatusCurso($curso);
			}
			return $id;
        }

		public function codigoAlunoTurma($idAluno){
			$data = null;
			$sql = "SELECT * FROM viewcodigoalunoturma WHERE usuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idAluno]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		protected function verifyTurma($idTurma){
			$data = null;
			$sql = "SELECT * FROM turma WHERE idTurma = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTurma]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		protected function editStatusCurso($idCurso){
			$estado = "Inactivo";
			$stmt = $this->connect();
			
            $sql = "UPDATE curso SET estado = ? WHERE idCurso = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($estado, $idCurso)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }
		
		protected function editTurma($idTurma, $capacidade){
			$decremento = $capacidade - 1;
			$stmt = $this->connect();
			
            $sql = "UPDATE turma SET capacidade = ? WHERE idTurma = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($decremento, $idTurma)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		protected function getTurma($periodo, $curso){
			$stmt = $this->connect();
            $sql = "SELECT * FROM turma WHERE idPeriodo = ? AND idCurso = ? AND NOT capacidade = 0 LIMIT 1";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$periodo, $curso]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function insertPeriodoCurso($idUsuario, $periodo, $curso){
			$stmt = $this->connect();
			$sql = "INSERT INTO periodoCursoAluno (aluno, periodo, curso) VALUES (?, ?, ?)";
			$query = $stmt->prepare($sql);
			$query->execute(array($idUsuario, $periodo, $curso));
        }

		protected function insertTurmaAluno($idTurma, $idAluno){
			$stmt = $this->connect();
			
            $sql = "INSERT INTO turmaaluno (turma, aluno) VALUES (?, ?)";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($idTurma, $idAluno)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function readTurma(){
			$data = null;
			$sql = "SELECT * FROM turma";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		protected function readTipoUsuario($idUsuario){
			$data = null;
			$sql = "SELECT * FROM usuario WHERE idUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function fotoPerfil($idUsuario){
			$data = null;
			$sql = "SELECT * FROM usuario WHERE idUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function eraseUsuario($idUsuario){
			$stmt = $this->connect();
            $sql = "DELETE FROM usuario WHERE idUsuario = ?";
            $query = $stmt->prepare($sql);
			$img = $this->fotoPerfil($idUsuario);
			$nameImg = "../../images/fotoPerfil/" . $img[0]["imagem"];
			$fileInfo = glob($nameImg);
			$fileExt = explode(".", $fileInfo[0]);
			$fileActualExt = $fileExt[5];
        	$file = $nameImg;
			unlink($file);
            if(!($query->execute(array($idUsuario)))){
				$query = null;
				exit();
			}
		}

		protected function editUsuario($idUsuario, $nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario, $ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido, $nomeCompletoImagem, $destinoFicheiro){
			$stmt = $this->connect();
			
            $sql = "UPDATE usuario SET nome = ?, email = ?, dataNasc = ?, telefone = ?, endereco = ?, bi = ?, genero = ?, idTipoUsuario = ?, imagem = ? WHERE idUsuario = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $email, $dataNasc, $telefone, $endereco, $bi, $genero, $tipoUsuario, $nomeCompletoImagem, $idUsuario)))){
				$query = null;
				exit();
			}
            move_uploaded_file($nomeTemporarioFicheiro, $destinoFicheiro);
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function listagemAluno(){
			$data = null;
			$sql = "SELECT * FROM viewusuariotipo WHERE idTipoUsuario = 2";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listagemProfessor(){
			$data = null;
			$sql = "SELECT * FROM viewusuariotipo WHERE idTipoUsuario = 3";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listagemUsuario(){
			$data = null;
			$sql = "SELECT * FROM viewusuariotipo WHERE NOT idTipoUsuario BETWEEN 2 AND 3";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

        public function queryEmail($email){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE email = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$email]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE email = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$email]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryBi($bi){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE bi = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$bi]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryNomeUsuario($nomeUsuario){
			$data = null;
			$sql = "SELECT COUNT(*) AS contador FROM usuario WHERE nomeUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$nomeUsuario]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function listaUsuario(){
			$data = null;
			$sql = "SELECT * FROM usuario";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryAluno($turma){
			$data = null;
			if($turma == 0){
				$sql = "SELECT * FROM turmaaluno ta INNER JOIN viewusuariotipo u ON (ta.aluno=u.idUsuario)";
				if($stmt = $this->connect()->query($sql)){
					while($row = $stmt->fetch()){
					$data[] = $row;
					}
				}
			} else {
				$sql = "SELECT * FROM turmaaluno ta INNER JOIN viewusuariotipo u ON (ta.aluno=u.idUsuario) WHERE ta.turma = ?";
				if($stmt = $this->connect()->prepare($sql)){
					$stmt->execute([$turma]);
					while($row = $stmt->fetch()){
					$data[] = $row;
					}
				}
			}
			return $data;
		}

		public function dataAluno($idAluno){
			$data = null;
			$sql = "SELECT * FROM viewdataaluno WHERE idTipoUsuario = 2 AND idUsuario = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idAluno]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}
    }