<?php
    class PermissaoModel extends Database {

		protected function insertDuracao($nome, $inicio, $final, $nota){
            $stmt = $this->connect();
            $sql = "INSERT INTO duracao (nome, inicio, final, nota) VALUES (?, ?, ?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($nome, $inicio, $final, $nota)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			$resultado = $this->getMonth($inicio, $final);
			for($i = 0; $i < count($resultado); $i++){
				$this->insertDuracaoCurso($id, $resultado[$i]["mes"]);
			}
			return $resultado;
        }

		protected function editDuracao($idDuracao, $nome, $inicio, $final, $nota){
			$stmt = $this->connect();
			
            $sql = "UPDATE duracao SET nome = ?, inicio = ?, final = ?, nota = ? WHERE idDuracao = ?";
            $query = $stmt->prepare($sql);

            if(!($query->execute(array($nome, $inicio, $final, $nota, $idDuracao)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		//SELECT @@lc_time_names; SET lc_time_names = 'pt_PT'; 
		public function lc_time_names($linguagem){
			$data = null;
			$sql = "SET lc_time_names = 'pt_PT'";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$linguagem]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function listagemDuracao(){
			$data = null;
			$sql = "SELECT * FROM duracao";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function permissaoData(){
			$data = null;
			$sql = "SELECT * FROM permissao";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data = $this->noData(0);
				}
			}
			return $data;
		}

		public function noData($parentId){
			$data = array();
			$sql = "SELECT * FROM permissao WHERE parent_id = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$parentId]);
				while($row = $stmt->fetch()){
					$sub_data = array();
					$sub_data['id'] = $row['idPermissao'];
					$sub_data['nome'] = $row['nome'];
					$sub_data['parent_id'] = $row['parent_id'];
					$sub_data['node'] = array_values($this->noData($row['idPermissao']));
					$data[] = $sub_data;
				}
			}
			return $data;
		}

		public function checkDuracaoCurso($idDuracao){
			$data = null;
			$sql = "SELECT * FROM duracaoCurso WHERE idDuracao = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idDuracao]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function checkDuracao($idDuracao){
			$data = null;
			$sql = "SELECT * FROM duracao WHERE idDuracao = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idDuracao]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			$meses = $this->getMonth($data[0]["inicio"], $data[0]["final"]);
			return $meses;
		}

		public function insertDuracaoCurso($idDuracao, $descricao){
            $stmt = $this->connect();
            $sql = "INSERT INTO duracaoCurso (idDuracao, descricao) VALUES (?, ?)";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idDuracao, $descricao)))){
				$query = null;
				exit();
			}
			$id = $stmt->lastInsertId();
			return $id;
        }

		public function getMonth($inicio, $final){
			$data = null;
			$lc = $this->lc_time_names('pt_PT');
			$sql = "SELECT DATE_FORMAT(m1, '%M - %Y') AS mes from (select ('$inicio' - INTERVAL DAYOFMONTH('$inicio')-1 DAY)+INTERVAL m MONTH as m1 from (select @rownum:=@rownum+1 as m from (select 1 union select 2 union select 3 union select 4) t1, (select 1 union select 2 union select 3 union select 4) t2, (select 1 union select 2 union select 3 union select 4)t3, (select 1 union select 2 union select 3 union select 4) t4, (select @rownum:=-1)t0)d1) d2 where m1<='$final' order by m1";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function queryDuracaoDois($idDuracao){
			$data = null;
			$sql = "SELECT * FROM duracao WHERE idDuracao = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idDuracao]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryDuracao($curso){
			$data = null;
			$sql = "SELECT * FROM viewduracaocurso WHERE idCurso = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$curso]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

		public function queryTipoTaxa($idTipoTaxa){
			$data = null;
			$sql = "SELECT * FROM tipotaxa WHERE idTipoTaxa = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idTipoTaxa]);
				while($row = $stmt->fetch()){
				$data[] = $row;
				}
			}
			return $data;
		}

        public function listaTipoTaxa(){
			$data = null;
			$sql = "SELECT * FROM tipotaxa";
			if($stmt = $this->connect()->query($sql)){
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function dataPeriodo($idPeriodo){
			$data = null;
			$sql = "SELECT * FROM periodo WHERE idPeriodo = ?";
			if($stmt = $this->connect()->prepare($sql)){
				$stmt->execute([$idPeriodo]);
				while($row = $stmt->fetch()){
				 $data[] = $row;
				}
			}
			return $data;
		}

		public function deleteDuracao($idDuracao){
			$stmt = $this->connect();
            $sql = "DELETE FROM duracao WHERE idDuracao = ?";
            $query = $stmt->prepare($sql);
            if(!($query->execute(array($idDuracao)))){
				$query = null;
				exit();
			}
		}
    }