<?php
	class ConfiguracaoController extends ConfiguracaoModel {
		private $titulo;
		private $telefone;
		private $email;
		private $endereco;
		private $rodape;
		private $codigoMoeda;
		private $simboloMoeda;
		private $nif;

		private $ficheiro;
		private $nomeFicheiro;
		private $tipoFicheiro;
		private $nomeTemporarioFicheiro;
		private $erroFicheiro;
		private $tamanhoFicheiro;
		private $extensaoFicheiro;
		private $extensaoActualFicheiro;
		private $permitido;

		private $nomeCompletoImagem;
		private $destinoFicheiro;

		public function setImagem($ficheiro, $nomeFicheiro, $tipoFicheiro, $nomeTemporarioFicheiro, $erroFicheiro, $tamanhoFicheiro, $extensaoFicheiro, $extensaoActualFicheiro, $permitido){
			$this->ficheiro = $ficheiro;
			$this->nomeFicheiro = $nomeFicheiro;
			$this->tipoFicheiro = $tipoFicheiro;
			$this->nomeTemporarioFicheiro = $nomeTemporarioFicheiro;
			$this->erroFicheiro = $erroFicheiro;
			$this->tamanhoFicheiro = $tamanhoFicheiro;
			$this->extensaoFicheiro = $extensaoFicheiro;
			$this->extensaoActualFicheiro = $extensaoActualFicheiro;
			$this->permitido = $permitido;

			$this->checks();
			$result = $this->insertImagem($this->ficheiro, $this->nomeFicheiro, $this->tipoFicheiro, $this->nomeTemporarioFicheiro, $this->erroFicheiro, $this->tamanhoFicheiro, $this->extensaoFicheiro, $this->extensaoActualFicheiro, $this->permitido, $this->nomeCompletoImagem, $this->destinoFicheiro);
			return $result;
		}

		public function checks(){
			if(in_array($this->extensaoActualFicheiro, $this->permitido)){
				if($this->erroFicheiro === 0){
					if($this->tamanhoFicheiro < 2000000){
						$this->nomeCompletoImagem = strtolower("logo") . "." . uniqid("", true) . "." . $this->extensaoActualFicheiro;
						$this->destinoFicheiro = "../images/logo/" . $this->nomeCompletoImagem;

					} else {
						echo "Imagem demasiado grande! Carregue imagens de proporções menores!";
						exit();
					}
				} else {
					echo "Erro ao carregar imagem!";
					exit();
				}
			} else {
				$this->nomeCompletoImagem = "default" . "." . uniqid("", true) . "." . "png";
				$this->destinoFicheiro = "../images/" . $this->nomeCompletoImagem;
				//echo "Erro ao carregar tipo de imagem! Carregue imagens dos tipos: jpg, jpeg e png.";
				//exit();

			}
		}

		public function getImagem(){
			return $this->nomeCompletoImagem;
		}

		public function setNif(string $nif){
			$this->nif = $nif;
			$result = $this->insertNif($this->nif);
			return $result;
		}

		public function getNif(){
			return $this->titulo;
		}

		public function setTitulo(string $titulo){
			$this->titulo = $titulo;
			$result = $this->insertTitulo($this->titulo);
			return $result;
		}

		public function getTitulo(){
			return $this->titulo;
		}

		public function setTelefone(string $telefone){
			$this->telefone = $telefone;
			$result = $this->insertTelefone($this->telefone);
			return $result;
		}

		public function getTelefone(){
			return $this->telefone;
		}

		public function setEmail(string $email){
			$this->email = $email;
			$result = $this->insertEmail($this->email);
			return $result;
		}

		public function getEmail(){
			return $this->email;
		}

		public function setEndereco(string $endereco){
			$this->endereco = $endereco;
			$result = $this->insertEndereco($this->endereco);
			return $result;
		}

		public function getEndereco(){
			return $this->endereco;
		}

		public function setRodape(string $rodape){
			$this->rodape = $rodape;
			$result = $this->insertRodape($this->rodape);
			return $result;
		}

		public function getRodape(){
			return $this->rodape;
		}

		public function setCodigoMoeda(string $codigoMoeda){
			$this->codigoMoeda = $codigoMoeda;
			$result = $this->insertCodigoMoeda($this->codigoMoeda);
			return $result;
		}

		public function getCodigoMoeda(){
			return $this->codigoMoeda;
		}

		public function setSimboloMoeda(string $simboloMoeda){
			$this->simboloMoeda = $simboloMoeda;
			$result = $this->insertSimboloMoeda($this->simboloMoeda);
			return $result;
		}

		public function getSimboloMoeda(){
			return $this->simboloMoeda;
		}
	}