<!DOCTYPE html>
<html lang="pt-pt">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Formulário curso</title>
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../../plugins/fontawesome-free/css/all.min.css">
  <!-- daterange picker -->
  <link rel="stylesheet" href="../../plugins/daterangepicker/daterangepicker.css">
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="../../plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Bootstrap Color Picker -->
  <link rel="stylesheet" href="../../plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css">
  <!-- Tempusdominus Bootstrap 4 -->
  <link rel="stylesheet" href="../../plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="../../plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="../../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
  <!-- Bootstrap4 Duallistbox -->
  <link rel="stylesheet" href="../../plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css">
  <!-- BS Stepper -->
  <link rel="stylesheet" href="../../plugins/bs-stepper/css/bs-stepper.min.css">
  <!-- dropzonejs -->
  <link rel="stylesheet" href="../../plugins/dropzone/min/dropzone.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../../dist/css/adminlte.min.css">
  <link rel="stylesheet" href="../../style.css">
</head>
<body class="sidebar-mini iframe-mode">
<div class="wrapper">
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <section class="content-header" style="padding: 10px .5rem;">
        </section>

        <!-- Main content -->
        <section class="content">
            <form action="../../includes/curso.inc.php" id="formularioCurso" method="post" enctype="multipart/form-data">
                <div class="container-fluid">
                    <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                        <div class="card card-default">
                            <div class="card-header">
                              <div class="col-sm-6">
                                <div class="form-group margem">
                                  <p class="card-title breadcrumb-item active" style="padding: .375rem;">Formulário - Curso</p>
                                </div>
                              </div>
                              <div class="float-sm-right col-md-2">
                                <div class="form-group margem">
                                  <a href="../listagem/curso.php" class="btn btn-block btn-outline-success">Listagem curso</a>
                                </div>
                              </div>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                            <div class="row">
                              <div class="col-md-2" style="text-align: -webkit-center;">
                                    <div class="form-group margem">
                                        <div class="wrapper-image">
                                            <div class="image-container">
                                                <i class="fa fa-image"></i>
                                            </div>
                                            <label for="file" class="camera-icon">
                                            <i class="fas fa-camera"></i>
                                            </label>
                                            <input type="file" id="file" name="file" accept="image/*" hidden>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group margem">
                                      <small class="required">Nome do Curso</small>
                                        <input type="text" class="form-control" id="nome" name="nome" placeholder="*Nome do curso" title="Nome do curso">
                                        <small>Mensagem de erro</small>
                                    </div>
                                    <div class="form-group margem">
                                      <small class="required">Período</small>
                                        <select class="form-control select2" style="width: 100%;" id="periodo" name="periodo" title="Período">
                                        </select>
                                        <small>Mensagem de erro</small>
                                    </div>
                                    <div class="form-group margem">
                                      <small class="required">Duração</small>
                                        <select class="form-control select2" style="width: 100%;" id="duracao" name="duracao" title="Duração">
                                        </select>
                                        <small>Mensagem de erro</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                  <div class="form-group margem">
                                    <small class="required">Preço</small>
                                    <input type="text" class="form-control" id="preco" name="preco" placeholder="Preço mensalidade" title="Preço mensal (curso)">
                                    <small>Mensagem de erro</small>
                                  </div>
                                  <div class="form-group margem">
                                    <small class="not-required">Nota</small>
                                    <textarea name="nota" class="form-control" id="nota" rows="1" placeholder="Nota..." title="Nota"></textarea>
                                    <small>Mensagem de erro</small>
                                  </div>
                                  <div class="form-group">
                                    <small>Botão</small>
                                    <button type="submit" name="btn-submit" id="btn-submit" class="btn btn-block btn-outline-primary" disabled>Cadastrar curso</button>
                                  </div>
                                </div>
                            </div>
                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer" style="padding-bottom: 0;">
                                <div class="callout callout-info">
                                    <p><i class="icon fas fa-exclamation-triangle"></i>
                                    Nota: Crie professor, classe e turno antes de criar estudante.</p>
                                </div>
                            </div>
                        </div>
                        </div>
                        <!-- /.col -->
                    </div>
                    <!-- /.row -->
                </div>
            </form>
        </section>
  </div>
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="../../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- Select2 -->
<script src="../../plugins/select2/js/select2.full.min.js"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="../../plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js"></script>
<!-- InputMask -->
<script src="../../plugins/moment/moment.min.js"></script>
<script src="../../plugins/inputmask/jquery.inputmask.min.js"></script>
<!-- date-range-picker -->
<script src="../../plugins/daterangepicker/daterangepicker.js"></script>
<!-- bootstrap color picker -->
<script src="../../plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<!-- Bootstrap Switch -->
<script src="../../plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
<!-- BS-Stepper -->
<script src="../../plugins/bs-stepper/js/bs-stepper.min.js"></script>
<!-- dropzonejs -->
<script src="../../plugins/dropzone/min/dropzone.min.js"></script>
<!-- AdminLTE App -->
<script src="../../dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="../../dist/js/demo.js"></script>
<script src="../../image.js"></script>
<script src="../../dist/js/sweetalert.min.js"></script>
<script src="../validation/formulario/curso.js"></script>
<!-- Page specific script -->
<script>
  $(function () {
    //Initialize Select2 Elements
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    });
  });

  $(document).ready(function(){
  $.ajax({
    url: "../../php/select/periodo.php",
    type: "post",
    dataType: "json",
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione periodo</option>";
      for(var key in data){
        select += "<option value="+data[key]['idPeriodo']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#periodo").html(select);
    }
  });
});

$(document).ready(function(){
  $.ajax({
    url: "../../php/select/duracao.php",
    type: "post",
    dataType: "json",
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione Duração</option>";
      for(var key in data){
        select += "<option value="+data[key]['idDuracao']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#duracao").html(select);
    }
  });
});

$(document).on("click", "#btn-submit", function(e){
  e.preventDefault();
  if(nome.value != '' && periodo.value != 0 && duracao.value != 0 && preco.value != ''){
    let img = $("#file")[0].files;
    curso(img);
  }
});

function foto(identificador, img){
  let form_data = new FormData();
    form_data.append('id', identificador);
    form_data.append('imagem', img[0]);

  $.ajax({
      url: "../../php/create/fotoCurso.php",
      type: "post",
      data: form_data,
      cache: false,
      contentType: false,
      processData: false,
      success: function(data){
        console.log("Foto cadastrada com sucesso!");
      }
    });
}

function curso(img){
  $.ajax({
        url: "../../php/create/curso.php",
        type: "post",
        data: {
        nome: nome.value,
        periodo: periodo.value,
        duracao: duracao.value,
        preco: preco.value,
        nota: nota.value
      },
      success: function(data){
        swal({
          title: "Cadastro efectuado com sucesso!",
          text: "Curso "+ nome.value +" cadastrado!",
          icon: "success",
        }).then(() => {
          if(img[0] != null){
            foto(data, img);
          }
        });
        nome.value = "";
        nome.className = "form-control";
        preco.value = "";
        preco.className = "form-control";
        nota.value = "";
        nota.className = "form-control";
        btn.setAttribute('disabled', 'disabled');
      },
      error: function(data){
        swal({
          title: "Erro ao cadastrar curso!",
          text: "Erro ao cadastrar curso: "+ titulo.value +" !",
          icon: "error",
      });
      }
    }).done(function(data){
        console.log(data);
    });
}
</script>
</body>
</html>
