<!DOCTYPE html>
<html lang="pt-pt">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Listagem curso</title>
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../../plugins/fontawesome-free/css/all.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="../../plugins/select2/css/select2.min.css">
  <link rel="stylesheet" href="../../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="../../plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="../../plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="../../plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../../dist/css/adminlte.min.css">
  <link rel="stylesheet" href="../../style.css">
</head>
<body class="sidebar-mini iframe-mode">
<div class="wrapper">
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header" style="padding: 10px .5rem;">
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
            <div class="row">
                <div class="col-12">

                <div class="card">
                    <div class="card-header">
                      <div class="col-sm-6">
                        <div class="form-group margem">
                          <p class="card-title breadcrumb-item active" style="padding: .375rem;">Listagem - Curso</p>
                        </div>
                      </div>
                      <div class="float-sm-right col-md-2">
                        <div class="form-group margem">
                          <a href="../formulario/curso.php" class="btn btn-block btn-outline-success">Adicionar curso</a>
                        </div>
                      </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                    <table id="tabelaCurso" class="table table-bordered table-striped" style="line-height: 0.8;">
                    <thead>
                        <tr>
                          <th title="Identificador do curso">Id curso</th>
                          <th title="Nome do curso">Nome</th>
                          <th title="Período do curso">Período</th>
                          <th title="Duração do curso">Duração</th>
                          <th title="Preço do curso">Preço</th>
                          <th title="Anotação do curso">Nota</th>
                          <th title="Estado curso (Activo, Inactivo)">Estado</th>
                        </tr>
                    </thead>
                    <tbody id="corpoTabela">
                        
                    </tbody>
                    </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
            </div>
        </section>
        <div class="modal fade" id="modal-updateCurso">
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header" style="padding: 0.5rem;">
                <h3 class="card-title p-3">Curso: <span id="nomeModal"></span></h3>
                <ul class="nav nav-pills ml-auto p-2">
                  <li class="nav-item" style="margin-right: 0.4rem;"><a class="nav-link active" href="#tab_info" data-toggle="tab">Informações</a></li>
                  <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" data-toggle="dropdown" href="#">
                      Acções <span class="caret"></span>
                    </a>
                    <div class="dropdown-menu">
                      <a class="dropdown-item" tabindex="-1" href="#tab_editar" data-toggle="tab">Editar</a>
                      <div class="dropdown-divider"></div>
                      <a class="dropdown-item" tabindex="-1" href="#btn-delete" id="btn-delete">Eliminar</a>
                    </div>
                  </li>
                </ul>
            </div>
            <div class="modal-body" style="padding-bottom: 0px;">
            <div class="tab-content">
              <div class="tab-pane active" id="tab_info">
                <div class="row">
                  <div class="col-md-12">
                  <form name="tabelaCurso">
                      <table name="tabelaCurso" class="table table-sm table-bordered" style="min-width: 100%;
                      max-width: 100%;">
                        <tr name="linhaItem">
                          <td style="padding: 20px 0px 0px 10px;">
                            <p>Código do curso: <span id="codigoInfo"></span></p>
                            <p>Nome do curso: <span id="nomeInfo"></span></p>
                            <p>Período curso: <span id="periodoInfo"></span></p>
                            <p>Duração curso: <span id="duracaoInfo"></span></p>
                            <p>Preço do curso: <span id="precoInfo"></span></p>
                            <p>Nota curso: <span id="notaInfo"></span></p>
                            <p>Estado curso (Activo, Inactivo): <span id="estadoInfo"></span></p>
                          </td>
                        </tr>
                      </table>
                    </form>
                  </div>
                </div>
              </div>
              <!-- /.tab-pane -->
              <div class="tab-pane" id="tab_editar">
              <div class="row">
                <div class="col-md-6">
                    <div class="form-group margem">
                        <input type="text" class="form-control" id="nome" name="nome" placeholder="*Nome do curso" title="Nome do curso">
                        <small>Mensagem de erro</small>
                    </div>
                    <div class="form-group margem">
                        <select class="form-control select2" style="width: 100%;" id="periodo" name="periodo" title="Período">
                        </select>
                        <small>Mensagem de erro</small>
                    </div>
                    <div class="form-group margem">
                        <select class="form-control select2" style="width: 100%;" id="duracao" name="duracao" title="Duração">
                        </select>
                        <small>Mensagem de erro</small>
                    </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group margem">
                    <input type="text" class="form-control" id="preco" name="preco" placeholder="Preço mensalidade" title="Preço mensal (curso)">
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group margem">
                    <textarea name="nota" class="form-control" id="nota" rows="1" placeholder="Nota..." title="Nota"></textarea>
                    <small>Mensagem de erro</small>
                  </div>
                  <div class="form-group">
                    <button type="submit" name="btn-submit" id="btn-submit" class="btn btn-block btn-outline-primary" disabled>Gravar alterações</button>
                  </div>
                </div>
            </div>
              </div>
            </div>
        </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
    <!-- /.content -->
  </div>
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->
<!-- jQuery -->
<script src="../../plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables  & Plugins -->
<script src="../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="../../plugins/jszip/jszip.min.js"></script>
<script src="../../plugins/pdfmake/pdfmake.min.js"></script>
<script src="../../plugins/pdfmake/vfs_fonts.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="../../plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
<script src="../../plugins/select2/js/select2.full.min.js"></script>
<!-- AdminLTE App -->
<script src="../../dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="../../dist/js/demo.js"></script>
<script src="../../dist/js/sweetalert.min.js"></script>
<script src="../validation/formulario/curso.js"></script>
<!-- Page specific script -->
<script>

$(function () {
    //Initialize Select2 Elements
    $('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    });
});

$(document).ready(function(){
    $.ajax({
        url: "../../php/selectAluno.php",
        type: "post",
        dataType: "json"
    }).done(function(data){
        console.log(data);
    });
});

$(document).ready(function(){
    $.ajax({
        url: "../../php/read/curso.php",
        type: "post",
        dataType: "json"
    }).done(function(data){
        $("#tabelaCurso").DataTable({
        "aaData": data,
        "columns": [{data: "idCurso"}, {data: "nome"}, {data: "periodo"}, {data: "duracao"}, {data: "preco"}, {data: "nota"}, {data: "estado"}],
        "responsive": true, "lengthChange": false, "autoWidth": false, "language": idiomaPortugues, 
        lengthMenu: [[7, 25, 50, -1], [10, 25, 50, 'All']], 
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#tabelaCurso_wrapper .col-md-6:eq(0)');
    });
});

var idiomaPortugues = {
  buttons: {
      copy: "Copiar",
      print: "Imprimir",
      colvis: "Visibilidade"
  },
  "sProcessing": "A processar...",
  "sLengthMenu": "Mostrar _MENU_ dos registros",
  "sZeroRecords": "Sem resultados!",
  "sEmptyTable": "Tabela sem dados disponíveis",
  "sInfo": "De _START_ à _END_ de um total de _TOTAL_ registros",
  "sInfoEmpty": "De 0 à 0 de um total de 0 registros",
  "sInfoFiltered": "(filtrado de um total de _MAX_ registros)",
  "sInfoPostFix": "",
  "sSearch": "Pesquisar:",
  "sUrl": "",
  "sInfoThousands": ",",
  "sLoadingRecords": "A carregar...",
  "oPaginate": {
      "sFirst": "Primeira",
      "sLast": "Última",
      "sNext": "Seguinte",
      "sPrevious": "Anterior"
  },
  "oAria": {
      "sSortAscending": ": Activar para ordenar a coluna de forma ascendente",
      "sSortDescending": ": Activar para ordenar a coluna de forma descendente"
  }
}

$(document).ready(function(){
  $.ajax({
    url: "../../php/select/periodo.php",
    type: "post",
    dataType: "json",
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione periodo</option>";
      for(var key in data){
        select += "<option value="+data[key]['idPeriodo']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#periodo").html(select);
    }
  });
});

$(document).ready(function(){
  $.ajax({
    url: "../../php/select/duracao.php",
    type: "post",
    dataType: "json",
    success: function(data){
      let select = "";
      select += "<option value='0'>Selecione Duração</option>";
      for(var key in data){
        select += "<option value="+data[key]['idDuracao']+">"+data[key]['nome']+"</option>";
      }
      console.log(select);
      $("#duracao").html(select);
    }
  });
});

$('#tabelaCurso tbody').on('click', 'td', function () {
    let tabela = document.getElementById("tabelaCurso");
    
    for(i = 1; i < tabela.rows.length; i++){
      tabela.rows[i].ondblclick = function(){
          idCurso = this.cells[0].innerHTML;
          nomeEdit = this.cells[1];
          periodoEdit = this.cells[2];
          duracaoEdit = this.cells[3];
          precoEdit = this.cells[4];
          notaEdit = this.cells[5];
          console.log(idCurso);
          ajax();
          //$('#modal-lg').modal('show');
          //this.classList.remove("selected");
      }
    }

    function ajax(){
      $.ajax({
        url: "../../php/read/queryCurso.php",
        type: "post",
        dataType: "json",
        data: {
          idCurso: idCurso
        },
        success: function(data){
          console.log(data);
          codigoInfo = document.getElementById("codigoInfo");
          nomeInfo = document.getElementById("nomeInfo");
          periodoInfo = document.getElementById("periodoInfo");
          duracaoInfo = document.getElementById("duracaoInfo");
          precoInfo = document.getElementById("precoInfo");
          notaInfo = document.getElementById("notaInfo");
          estadoInfo = document.getElementById("estadoInfo");

          nomeUpdate = document.getElementById("nome");
          periodoUpdate = document.getElementById("periodo");
          duracaoUpdate = document.getElementById("duracao");
          precoUpdate = document.getElementById("preco");
          notaUpdate = document.getElementById("nota");
          
          for(var key in data){
            console.log(data);
            nomeModal.innerText = data[key]['nome'];
            codigoInfo.innerText = data[key]['idCurso'];
            nomeInfo.innerText = data[key]['nome'];
            periodoInfo.innerText = data[key]['periodo'];
            duracaoInfo.innerText = data[key]['duracao'];
            precoInfo.innerText = data[key]['preco'];
            notaInfo.innerText = data[key]['nota'];
            estadoInfo.innerText = data[key]['estado'];

            nomeUpdate.value = data[key]['nome'];

            $('#periodo').val(data[key]['idPeriodo']);
            $('#periodo').select2().trigger('change');

            $('#duracao').val(data[key]['idDuracao']);
            $('#duracao').select2().trigger('change');

            precoUpdate.value = data[key]['preco'];
            notaUpdate.value = data[key]['nota'];
          }
        }
      }).done(function(data){
        $('#modal-updateCurso').modal('show');
      });
      
    }
});

$(document).on("click", "#btn-submit", function(e){
  e.preventDefault();
  console.log("Cliquei!!!");

  swal({
    title: "Tem a certeza que pretende editar dados?",
    text: "Curso: "+ nome.value,
    icon: "warning",
    buttons: true,
  })
  .then((willUpdate) => {
  if (willUpdate) {
   $.ajax({
        url: "../../php/update/curso.php",
        type: "post",
        data: {
        idCurso: idCurso,
        nome: nomeUpdate.value,
        periodo: periodoUpdate.value,
        duracao: duracaoUpdate.value,
        preco: precoUpdate.value,
        nota: notaUpdate.value
      },
      success: function(data){
        console.log(data);
        nomeEdit.innerText = nomeUpdate.value;

        var periodo = $("#periodo").select2('data');
        periodoEdit.innerText = periodo[0].text;

        var duracao = $("#duracao").select2('data');
        duracaoEdit.innerText = duracao[0].text;
        
        precoEdit.innerText = precoUpdate.value;
        notaEdit.innerText = notaUpdate.value;
        swal({
          title: "Alterações gravadas com sucesso!",
          text: "Curso "+ nomeUpdate.value +" editado!",
          icon: "success",
        });
      }
    });
  }
});
});

$(document).on("click", "#btn-delete", function(e){
  e.preventDefault();
  swal({
    title: "Tem a certeza que pretende eliminar curso?",
    text: "Curso: "+ nome.value,
    icon: "warning",
    buttons: true,
    dangerMode: true,
  })
  .then((willDelete) => {
    if (willDelete) {
      $.ajax({
        url: "../../php/delete/curso.php",
        type: "post",
        dataType: "json",
        data: {
          idCurso: idCurso
      },
      success:function(data){
        console.log(data);
        updateTable();
        swal("Curso "+ nome.value +" eliminado com sucesso!", {
        icon: "success",
      });
      },
      error: function(data){
        swal({
          title: "Erro ao eliminar curso!",
          text: "Erro ao apagar curso: "+ nome.value +" !",
          icon: "error",
      });
      }
      });
    }
  });
});

function updateTable(){

$.ajax({
      url: "../../php/read/curso.php",
      type: "post",
      dataType: "json"
  }).done(function(data){
    console.log("Está aqui a lista de alunos filtrada: ", data);
    $("#tabelaCurso").DataTable().clear().draw();
    $("#tabelaCurso").DataTable().rows.add(data);
    $("#tabelaCurso").DataTable().columns.adjust().draw();
  });
}
</script>
</body>
</html>
